﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace Common_Tools.Web_Help
{
    public class SendPay
    {

        /// <summary>
        /// 发送
        /// </summary>
        /// <param name="price">商品金额</param>
        /// <param name="shopName">商品名称</param>
        /// <param name="shopNum">商户订单号</param>
        /// <param name="paytype">支付方式</param>
        /// <param name="str"></param>
        public static String CreatePay(string price, string shopName, string shopNum, string paytype,out bool str) 
        {
            //UTF-8格式：   String encode="UTF-8"
            String clientip = Net.Ip;  //用户IP地址
            String device = "mobile";  //设备类型
            String money = price;  //商品金额
            String name = shopName;  //商品名称
            String notify_url = "www.baidu.com";  //异步通知地址
            String out_trade_no = shopNum;  //商户订单号
            String param = "无";  //业务扩展参数
            String pid = "1000";  //商户ID
            String return_url = "www.baidu.com";  //跳转通知地址
            String type = paytype;  //支付方式
            StringBuilder Temp = new StringBuilder();
            Temp.Append("clientip=" + clientip + "&device=" + device + "&money=" + money + "&name=" + name + "&notify_url=" + notify_url + "&out_trade_no=" + out_trade_no + "&param=" + param + "&pid=" + pid + "&return_url=" + return_url + "&type=" + type + "WBZHZWBeheKhWZcKuGRlb8lKWzwCWUeH");
            String sign = Encryption.md5(Temp.ToString()).ToLower();  //签名字符串
            String sign_type = "MD5";  //签名类型
            //新建一个StringBuilder类
            StringBuilder sbTemp = new StringBuilder();
            //发送链接
            sbTemp.Append("pid=" + pid + "&type=" + type + "&out_trade_no=" + out_trade_no + "&notify_url=" + notify_url + "&return_url=" + return_url + "&name=" + name + "&money=" + money + "&clientip=" + clientip + "&device=" + device + "&param=" + param + "&sign=" + sign + "&sign_type=" + sign_type);
            //对内容做Urlencode编码操作。
            byte[] bTemp = System.Text.Encoding.GetEncoding("UTF-8").GetBytes(sbTemp.ToString());
            //发送返回的结果存入result中
            String result = PostRequest("https://api.payqqpay.cn/mapi.php", bTemp);  
            if (result.Contains(":1"))
            {
                str = true;
            }
            else
            {
                str = false;
            }
            return result.ToString();
        }
        //POST方式发送得结果
        private static String PostRequest(string url, byte[] bData)
        {
            System.Net.HttpWebRequest hwRequest;
            System.Net.HttpWebResponse hwResponse;
            string strResult = string.Empty;
            try
            {
                //获取上面的URL链接
                hwRequest = (System.Net.HttpWebRequest)System.Net.WebRequest.Create(url);
                //设置超时时间
                hwRequest.Timeout = 5000;
                //发送请求为POST
                hwRequest.Method = "POST";
                hwRequest.ContentType = "application/x-www-form-urlencoded";
                //bData的长度（也就是获取用内容，编码格式总长度）
                hwRequest.ContentLength = bData.Length;
                //发送
                System.IO.Stream smWrite = hwRequest.GetRequestStream();
                smWrite.Write(bData, 0, bData.Length);
                //释放资源
                smWrite.Close();
            }
            catch (System.Exception err)
            {
                WriteErrLog(err.ToString());
                return strResult;
            }

            //get response
            try
            {
                //使用hwResponse来获取数据
                hwResponse = (HttpWebResponse)hwRequest.GetResponse();
                StreamReader srReader = new StreamReader(hwResponse.GetResponseStream(), Encoding.ASCII);
                strResult = srReader.ReadToEnd();
                srReader.Close();
                hwResponse.Close();
            }
            catch (System.Exception err)
            {
                WriteErrLog(err.ToString());
            }

            return strResult;
        }
        //URLencode编码
        public static string UrlEncode(string str)
        {
            StringBuilder sb = new StringBuilder();
            byte[] byStr = System.Text.Encoding.UTF8.GetBytes(str); //默认是System.Text.Encoding.Default.GetBytes(str)
            for (int i = 0; i < byStr.Length; i++)
            {
                sb.Append(@"%" + Convert.ToString(byStr[i], 16));
            }

            return (sb.ToString());
        }
        private static void WriteErrLog(string strErr)
        {
            Console.WriteLine(strErr);
            System.Diagnostics.Trace.WriteLine(strErr);
        }
    }
}
