package com.pay.utile;

import cn.hutool.extra.qrcode.QrCodeUtil;
import cn.hutool.extra.qrcode.QrConfig;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import com.pay.utile.MD5Util;
import com.sun.org.apache.bcel.internal.generic.NEW;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;


import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 *

public class PayUtil {


    public void toImGES(HttpServletResponse response, String orderId, String name, double money, String
            clientip) {
        //API接口支付
        String url = "https://api.payqqpay.cn/mapi.php";
        //pid={商户ID}&type={支付方式}&out_trade_no={商户订单号}&notify_url={服务器异步通知地址}&return_url={页面跳转通知地址}&name={商品名称}&money={金额}&clientip={用户IP地址}&device={设备类型}&sign={签名字符串}&sign_type=MD5
        String out_trade_no = orderId, sign = "";
        //[clientip, device, money, name, notify_url, out_trade_no, pid, return_url, sign_type, type]
        //封装好我们的请求参数
        String mdString = "clientip=" + clientip + "&device=" + PayConfig.device + "&money=" + money + "&name=" + name + "&" +
                "notify_url=" + PayConfig.notify_url + "&out_trade_no=" + out_trade_no + "&pid=" + PayConfig.pid + "&return_url=" + PayConfig.return_url +
                "&type=" + PayConfig.type + PayConfig.key;
        //把我们的请求参数 md5加密
        sign = MD5Util.GetMD5Code(mdString);

        //封装我们的请求参数 调用的api  是我们
        Map<String, Object> map = new HashMap<>();
        map.put("clientip", clientip);
        map.put("device", PayConfig.device);
        map.put("money", money);
        map.put("name", name);
        map.put("notify_url", PayConfig.notify_url);
        map.put("out_trade_no", out_trade_no);
        map.put("pid", PayConfig.pid);
        map.put("return_url", PayConfig.return_url);
        map.put("sign_type", PayConfig.sign_type);
        map.put("type", PayConfig.type);
        map.put("sign", sign);
        String body = HttpUtil.post(url, map);
        System.out.println(body);
        JSONObject jsonObject = new JSONObject(body);
        //拿到我们的返回的wx支付的url  转成二维码显示到前端
        String wxUrl = (String) jsonObject.get("qrcode");
        try {
            QrConfig config = new QrConfig(300, 300);
            QrCodeUtil.generate(wxUrl, config, "png", response.getOutputStream());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}