
//此列子为后端api获取支付跳转链接.前端直接跳转，整个流程就是这样，字符串留空的填上自己的逻辑就行。
 //payReq是本列子自定义的请求类，可以忽略，CommonHttp.sendPost也是本列子封装的请求类，可以用自己项目里自己封装的请求，项目基于Springboot开发
//少包的去看文件夹里面的Map降序排序方法或者查看demo完整版
//post请求的参数代码自行百度搜索或者查看demo完整版

public String getPayUrl(PayReq payReq) throws AlipayApiException {
        Map<String, Object> params = new HashMap<>();
        params.put("pid", "");
        params.put("type", payReq.getType());
        params.put("out_trade_no", payReq.getOutTradeNo());
        params.put("notify_url", "");
        params.put("return_url", "");
        params.put("name", payReq.getSubject());
        params.put("money", payReq.getTotalAmount());
        params.put("clientip", payReq.getIp());
        params = CopyUtil.sortByKey(params);
        StringBuilder signStr = new StringBuilder();
        for (Map.Entry<String, Object> m : params.entrySet()) {
            signStr.append(m.getKey()).append("=").append(m.getValue()).append("&");
        }
        signStr = new StringBuilder(signStr.substring(0, signStr.length() - 1));
        signStr.append("");
        LOG.info("待签名字符串:" + signStr);
        signStr = new StringBuilder(DigestUtils.md5DigestAsHex(signStr.toString().getBytes()));
        params.put("sign_type", "MD5");
        params.put("sign", signStr.toString());
        LOG.info("sign:" + params.get("sign"));
        CloseableHttpResponse getUrlResponse;
        String url = "";

        try {
            getUrlResponse = CommonHttp.sendPost("https://api.payqqpay.cn/mapi.php", params, null, 0);
//            int statusGet = getUrlResponse.getStatusLine().getStatusCode();
            HttpEntity responseEntity = getUrlResponse.getEntity();
            String resultGet = EntityUtils.toString(responseEntity, "UTF-8");
            LOG.info(resultGet);
            // parsing JSON
            JSONObject resultPay = JSON.parseObject(resultGet); //Convert String to JSON Object
            String payurl = resultPay.getString("payurl");
            String qrcode = resultPay.getString("qrcode");
            if (payurl==null && !Objects.equals(qrcode, "")) {
                url = qrcode;
            } else if (!Objects.equals(payurl, "") && qrcode==null) {
                url = payurl;

   }   